# Copyright (C) 2000 by Dr. Dieter Maurer <dieter@handshake.de>
# D-66386 St. Ingbert, Eichendorffstr. 23, Germany
#
#			All Rights Reserved
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted,
# provided that the above copyright notice and this permission
# notice appear in all copies, modified copies and in
# supporting documentation.
# 
# Dieter Maurer DISCLAIMS ALL WARRANTIES WITH
# REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL Dieter Maurer
# BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
# DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
# PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
# TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
# PERFORMANCE OF THIS SOFTWARE.
"""struct <-> class conversion."""

import struct, string
from types import StringType

class StructClass:
  """a class with conversion to/from struct."""
  # overwritten by derived classes
  _StructFormat= None # a struct format string
  _Members= None # the list of members corresponding to _StructFormat
  #
  def __init__(self,*args):
    if len(args) == 1 and type(args[0]) == StringType:
      apply(self.__init__,struct.unpack(self._StructFormat,args[0]))
    else:
      if len(args) != len(self._Members):
	raise TypeError,"Wrong number of arguments: %d rather than %d" % (len(args), len(self._Members))
      for (m,v) in map(None,self._Members,args): setattr(self,m,v)
  #
  def toString(self):
    return apply(struct.pack,
		 (self._StructFormat,) + tuple(map(self.getattr,self._Members)))
  #
  def __str__(self):
    return string.join(map(self._formatMember,self._Members),', ')
  #
  def getattr(self,k): return getattr(self,k)
  def _formatMember(self,k): return "%s= %s" % (k,self.getattr(k))


def genStructClass(clname,*members):
  """generate StructClass *clname* with *members*.

  Each *member* is either a pair (*struct_format*,*name*) or a string.
  If a string, the first character is used as *struct_format*, the
  rest as name.
  """
  d={}; exec("class %s(StructClass): pass" % clname, globals(),d)
  c= d[clname]
  _format= []; _members= []
  for m in members:
    _format.append(m[0])
    if type(m) is StringType: n= m[1:]
    else: n= m[1]
    _members.append(n)
  c._StructFormat= string.join(_format)
  c._Members= _members
  return c



