# $Id: test_pattern.py,v 1.1 1999/04/11 16:09:15 dieter Exp dieter $
"""Test for XSLPattern."""

from xml.dom.sax_builder import SaxBuilder
from xml.sax.saxexts import make_parser
from xml.sax.saxutils import ErrorPrinter
from dmutil.xsl.pattern import Parser, IdDecl
import dmutil.xsl 

##############################################################################
# build a DOM tree
dh= SaxBuilder()
p= make_parser(); p.setDocumentHandler(dh); p.setErrorHandler(ErrorPrinter())
p.parse('%s/test_pattern.xml' % dmutil.xsl.__path__[0]); p.close()
domtree= dh.document

##############################################################################
# create an idmap provider
#   this is only necessary when "id" patterns are used
idmapprovider= IdDecl(['id'])
# apply it to "domtree"
#   this gives "domtree" the infrastructure for "id" pattern handling
idmapprovider(domtree)


##############################################################################
# selections
# select by id
p= Parser('id("xslpattern")')
s= p.select(domtree)
if len(s) != 1: print 'id-pattern selection failed'

# select by element type
p= Parser('//product')
s= p.select(domtree)
if len(s) != 3: print 'element type selection failed'

# select by element type with subelement test
p= Parser('//product[name="XSL-Pattern"]')
s= p.select(domtree)
if len(s) != 1: print 'element selection with subelement test failed'

# select subelement and text
p= Parser('//vendor[name="Dieter Maurer"]/email/text()')
s= p.select(domtree)
if len(s) != 1 or s[0].nodeValue != 'dieter@handshake.de':
  print 'text(subelement) selection failed'

# select first-of-any
p= Parser('*/*[first-of-any()]')
s= p.select(domtree)
if len(s) != 1 or s[0].nodeName != 'vendor':
  print 'first-of-any selection failed'

p= Parser('*/product[first-of-any()]')
s= p.select(domtree)
if len(s) != 0: print 'first-of-any selection failed (nonfirst element)'

# select first-of-type
p= Parser('*/product[first-of-type()]')
s= p.select(domtree)
if len(s) != 1 or Parser('@id').select(s[0])[0].nodeValue != 'weakdict':
  print 'first-of-type selection failed'

# select last-of-type
p= Parser('*/*[last-of-type()]')
s= p.select(domtree)
if len(s) != 2: print 'last-of-type selection failed'

# select last-of-any
p= Parser('*/*[last-of-any()]')
s= p.select(domtree)
if len(s) != 1: print 'last-of-any selection failed'

# select ancestor
p= Parser('//version[.="0.02"]/ancestor(.[@id="addcontenttable"])')
s= p.select(domtree)
if len(s) != 1: print 'ancestor selection failed'

# select parent
p= Parser('//version[.="0.02"]/..')
s= p.select(domtree)
if len(s) != 2: print 'parent selection failed'

# select not
p= Parser('//version[not(.="0.02")]/..')
s= p.select(domtree)
if len(s) != 1: print 'not selection failed'

# select or
p= Parser('//product[version="0.01" or @id="addcontenttable"]')
s= p.select(domtree)
if len(s) != 2: print 'or selection failed'

# select and
p= Parser('//product[version="0.02" and @id="addcontenttable"]')
s= p.select(domtree)
if len(s) != 1: print 'and selection failed'

# select and/or
p= Parser('//product[(version="0.02" and @id="addcontenttable") or version="0.01"]')
s= p.select(domtree)
if len(s) != 2: print 'and selection failed'

# select attribute wildcard
p= Parser('//*[@*="addcontenttable"]')
s= p.select(domtree)
if len(s) != 1: print 'attribute wildcard selection failed'


###############################################################################
# matching

# element test
p= Parser('*')
xsa=p.select(domtree)[0]
if not p.match(xsa) or p.match(domtree):
  print 'element test failed'

if not Parser('xsa').match(xsa) or Parser('vendor').match(xsa):
  print 'element test(2) failed'

# basenode
bn=Parser('product[@id="weakdict"]').select(xsa)[0]

# has subelement
if not Parser('.[version]').match(bn) or Parser('.[email]').match(bn):
  print 'has subelement failed'

# ancestor path
if not Parser('xsa/product').match(bn) or Parser('email/product').match(bn):
  print 'ancestor path test failed'

# is ancestor
if not Parser('.[.//version[.="0.02"]]').match(xsa) \
   or Parser('.[.//version[.="1"]]').match(xsa):
  print 'is ancestor test failed'

# is nearest ancestor matching ...
if not Parser('//version[.="0.02"]/ancestor(xsa)').match(xsa) \
   or Parser('//version[.="0.02"]/ancestor(*)').match(xsa):
  print 'is nearest ancestor test failed'

# has id
p= Parser('id("weakdict")')
if not p.match(bn) or p.match(xsa):
  print 'has id test failed'

# is parent of
p= Parser('version[.="0.01"]/..')
if not p.match(bn) or p.match(xsa):
  print 'is parent test failed'

# is first-of-type
if not Parser('.[first-of-type()]').match(bn):
  print 'first-of-type test failed'

# is first-of-any
if Parser('.[first-of-any()]').match(bn):
  print 'first-of-any test failed'

# is descendent of
p= Parser('xsa//.')
if not p.match(bn) or not p.match(xsa):
  print 'is descendent test failed'

p= Parser('xsa//*')
if not p.match(bn) or p.match(xsa):
  print 'is descendent test(2) failed'


