--- :bisonparser.py	Wed Jan 29 22:43:29 1997
+++ bisonparser.py	Wed Nov 25 13:44:54 1998
@@ -19,8 +19,9 @@
 ## YACC PARSER
 
 class BisonParser:
-  def __init__(self, module):
+  def __init__(self, module, env=None):
     self.module = module
+    self.env = env
     self.yylval = None
 
     self.lasttoken = len(self.module.yytranslate)
@@ -180,7 +181,9 @@
   ##  print
 
     if rule:
-      self.val = apply(rule, (self.vs, len(self.vs)-self.len-1, self.lval))
+      env= self.env
+      if env is None: env= self
+      self.val = apply(rule, (self.vs, len(self.vs)-self.len-1, self.lval, env))
     else:
   ##    print "|| default applying", yyn
       if self.len == 1:
--- :bison2python.py	Wed Jan 29 21:49:19 1997
+++ bison2python.py	Tue Nov 24 23:28:32 1998
@@ -32,7 +32,7 @@
     if line[:5] == "case ":
       rule = string.atoi(line[4:-1])
       print
-      print "def rule_%d(yyvs, yyvsp, yylval):" % rule
+      print "def rule_%d(yyvs, yyvsp, yylval, yyenv):" % rule
       print "    yyval = None"
       incase = 1
       continue
