/* $Id: patternparser.y,v 1.1 1999/01/15 20:18:32 dieter Exp $ */
/*
Copyright (C) 1999 by Dr. Dieter Maurer <dieter@handshake.de>
D-66386 St. Ingbert, Eichendorffstr. 23, Germany

		All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and
modified copies and that
both that copyright notice and this permission notice appear in
supporting documentation.

Dieter Maurer DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL Dieter Maurer
BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
*/

%{
/*py
from xml.dom import core
*/
  %}


%token QNAME LITERAL
%token PARENT
%token AND OR
%token ID ANCESTOR ANCESTOR_OR_SELF COMMENT PI TEXT NOT FIRST_OF_TYPE LAST_OF_TYPE FIRST_OF_ANY LAST_OF_ANY

%%

/* a Pattern */
SelectExpr: UnionExpr {
  /*py
    $$= yyenv.Pattern($1)
  */
}
;

/* a list of PathExpr */
UnionExpr: PathExpr {
  /*py
    $$= [$1]
  */
}
| PathExpr '|' UnionExpr {
  /*py
    $$= $3; $$.append($1)
  */
}
;

/* a list of Navigators */
PathExpr: AbsolutePathExpr | ComposeExpr
;

/* a list of Navigators */
AbsolutePathExpr: '/' {
  /*py
    $$= [yyenv.ROOT]
  */
}
| '/' SubtreeExpr {
  /*py
    $$= $2; $$.insert(0,yyenv.ROOT)
  */
}
;

/* a list of Navigators */
SubtreeExpr: '/' ComposeExpr {
  /*py
    $$= $2; $$.insert(0,yyenv.DESCENDANTS)
  */
}
| ComposeExpr
;

/* a list of Navigators */
ComposeExpr: FilterExpr {
  /*py
    $$= [$1]
  */
}
| FilterExpr '/' SubtreeExpr {
  /*py
    $$= $3; $$.insert(0,$1)
  */
}
;

/* a NodeExpr */
FilterExpr: NodeExpr
| NodeExpr '[' BooleanExpr ']' {
  /*py
    $$= $1; $$.addFilter($3)
  */
}
;

NodeExpr: QNAME {
  /*py
    $$= yyenv.Element($1)
  */
}
| '*' {
  /*py
    $$= yyenv.Element()
  */
}
| '@' QNAME {
  /*py
    $$= yyenv.Attribute($2)
  */
}
| '@' '*' {
  /*py
    $$= yyenv.Attribute()
  */
}
| PI '(' ')' {
  /*py
    $$= yyenv.SubNode(core.PROCESSING_INSTRUCTION)
  */
}
| PI '(' LITERAL ')' {
  /*py
    $$= yyenv.SubNode(core.PROCESSING_INSTRUCTION,$3)
  */
}
| TEXT '(' ')' {
  /*py
    $$= yyenv.SubNode(core.TEXT)
  */
}
| COMMENT '(' ')' {
  /*py
    $$= yyenv.SubNode(core.COMMENT)
  */
}
| ID '(' LITERAL ')' {
  /*py
    $$= yyenv.Id($3)
  */
}
| ID '(' SelectExpr ')' {
  /*py
    $$= yyenv.Id($3)
  */
}
| ANCESTOR '(' SelectExpr ')' {
  /*py
    $$= yyenv.Ancestor($3, 0)
  */
}
| ANCESTOR_OR_SELF '(' SelectExpr ')' {
  /*py
    $$= yyenv.Ancestor($3, 1)
  */
}
| '.' {
  /*py
    $$= yyenv.Identity()
  */
}
| PARENT {
  /*py
    $$= yyenv.Parent()
  */
}
;


BooleanExpr: BooleanPrimaryExpr
| BooleanPrimaryExpr OrExprSuffix {
  /*py
    $$= $2; $$.add($1)
  */
}
| BooleanPrimaryExpr AndExprSuffix {
  /*py
    $$= $2; $$.add($1)
  */
}
;

OrExprSuffix: OR BooleanPrimaryExpr {
  /*py
    $$= yyenv.Or($2)
  */
}
| OR BooleanPrimaryExpr OrExprSuffix {
  /*py
    $$= $3; $$.add($2)
  */
}
;

AndExprSuffix: AND BooleanPrimaryExpr {
  /*py
    $$= yyenv.And($2)
  */
}
| AND BooleanPrimaryExpr AndExprSuffix {
  /*py
    $$= $3; $$.add($2)
  */
}
;

BooleanPrimaryExpr: BooleanGroupExpr
| NotExpr
| PositionalExpr
| TestExpr
| EqualityExpr
;

BooleanGroupExpr: '(' BooleanExpr ')' {
  /*py
    $$= $2
  */
}
;

NotExpr: NOT '(' BooleanExpr ')' {
  /*py
    $$= yyenv.Not($3)
  */
}
;

PositionalExpr: FIRST_OF_TYPE '(' ')' {
  /*py
    $$= yyenv.PosChecker(-1,1)
  */
}
| LAST_OF_TYPE '(' ')' {
  /*py
    $$= yyenv.PosChecker(1,1)
  */
}
| FIRST_OF_ANY '(' ')' {
  /*py
    $$= yyenv.PosChecker(-1,0)
  */
}
| LAST_OF_ANY '(' ')' {
  /*py
    $$= yyenv.PosChecker(1,0)
  */
}
;

TestExpr: SelectExpr {
  /*py
    $$= yyenv.Tester($1)
  */
}
;

EqualityExpr: SelectExpr '=' LITERAL {
  /*py
    $$= yyenv.Tester($1,$3)
  */
}
;
